create external table IF NOT EXISTS ${SOURCE_TABLE_NAME} (json STRING) STORED AS TEXTFILE LOCATION '${SOURCE_TABLE_DIRECTORY}' ;
create external table IF NOT EXISTS ${TARGET_TABLE_NAME} (json STRING) STORED AS TEXTFILE LOCATION '${TARGET_TABLE_DIRECTORY}' ;
create external table IF NOT EXISTS ${TABLE_NAME} (json STRING) STORED AS TEXTFILE LOCATION '${TABLE_DIRECTORY}' ;
set hive.auto.convert.join.noconditionaltask.size = 500000000;
ADD JAR ${PATH_TO_JAR};
CREATE TEMPORARY FUNCTION MergeArrayOfJSON as 'edu.isi.karma.mapreduce.function.MergeArrayOfJSON';
CREATE TEMPORARY FUNCTION CollectJSONObject as 'edu.isi.karma.mapreduce.function.CollectJSONObject';
CREATE TEMPORARY FUNCTION SplitAndCleanJSONArray as 'edu.isi.karma.mapreduce.function.SplitAndCleanJSONArray';
INSERT OVERWRITE TABLE ${TABLE_NAME}
select MergeArrayOfJSON(d.json, collect_set(source_table.json), '${JSON_PATH_TO_MERGE}','${ATID}') from ${SOURCE_TABLE_NAME} source_table right outer join
        ( select b.json as json, b.id as id, trim(c.uri_to_merge) as uri_to_merge from
                (select a.json as json, a.id as id, SplitAndCleanJSONArray(if(a.uris_to_merge_string IS NULL, "", a.uris_to_merge_string)) as uris_to_merge_array from
                        (select json, CollectJSONObject(json,"$.${ATID}") as id, CollectJSONObject(json, '${JSON_PATH_FOR_MERGE_URIS}') as uris_to_merge_string from
                                ${TARGET_TABLE_NAME}
                        ) a
                ) b  lateral view explode(uris_to_merge_array) c as uri_to_merge
        ) d
on d.uri_to_merge == translate(CollectJSONObject(source_table.json,"$.${ATID}"), "[]\"","") group by d.id, d.json;
drop table ${SOURCE_TABLE_NAME};
drop table ${TARGET_TABLE_NAME};
drop table ${TABLE_NAME};